//========================================================================================================================
//
//                                                     Map Engine
//
//========================================================================================================================

//========================================================================================================================
//                                                     Object
//========================================================================================================================

function _mapEngine()
{
  //var time = GetTime();
  this.x = 0;
  this.y = 0;
  this.w = 640;
  this.h = 480;
  this.tileX = 0;
  this.tileY = 0;
  this.tileH = this.h / 32;
  this.tileW = this.w / 32;
  
  this.tilesetImage = LoadSurface("../maps/Tileset.png");
  this.tileset = [];
  
  var x = 0;
  var y = 0;
  for (var i = 0; i < (this.tilesetImage.width / 32) * (this.tilesetImage.height / 32); i++)
  {
    this.tileset[i] = new Object;
    this.tileset[i].image = this.tilesetImage.cloneSection(0 + (x * 32), 0 + (y * 32), 32, 32).createImage();
    x++
    if (x == 6)
    {
      x = 0;
      y++;
    }
  }
  
  this.map = OpenFile("../maps/Map0.nmp");
  this.width = this.map.read("width", 40);
  this.height = this.map.read("height", 40);
  this.numLayers = this.map.read("numLayers", 2);
  this.layer = [];
  this.numMapObjects = this.map.read("numMapObjects", 0);
  this.mapObjects = [];
  for (var l = 0; l < this.numLayers; l++)
  {
    this.layer[l] = [];
    this.layer[l].base = [];
    this.layer[l].objects = [];
    this.layer[l].entities = [];
    for (var i = 0; i < this.map.read("mapEntities[" + l + "].num", 0); i++)
    {
      var item = new Object;
      item.x = this.map.read("mapEntities[" + l + "][" + i + "].x", undefined);
      item.y = this.map.read("mapEntities[" + l + "][" + i + "].y", undefined);
      item.tileX = this.map.read("mapEntities[" + l + "][" + i + "].tileX", undefined);
      item.tileY = this.map.read("mapEntities[" + l + "][" + i + "].tileY", undefined);
      this.layer[l].entities[this.layer[l].entities.length] = item;
    }
    for (var y = 0; y < this.height; y++)
    {
      this.layer[l].base[y] = [];
      this.layer[l].objects[y] = [];
      for (var x = 0; x < this.width; x++)
      {
        this.layer[l].base[y][x] = this.map.read("mapTile[" + l + "][" + y + "]["  + x + "]", 0);
        this.layer[l].objects[y][x] = this.map.read("mapObject[" + l + "][" + y + "][" + x + "]", undefined);
        if (this.layer[l].objects[y][x] == "undefined") this.layer[l].objects[y][x] = undefined;
      }
    }
  }
  this.map.close();
}

//========================================================================================================================
//                                                     Update
//========================================================================================================================

_mapEngine.prototype.update = function()
{
  
}

//========================================================================================================================
//                                                     Handle Input
//========================================================================================================================

_mapEngine.prototype.handleInput = function()
{
  while (AreKeysLeft()) 
  {   
    switch (GetKey()) 
    {
      case KEY_DOWN: 
      {
        return this.y++;
      }
      case KEY_LEFT: 
      {
        return this.x--;
      }
      case KEY_UP: 
      {
        return this.y--;
      }
      case KEY_RIGHT: 
      {
        return this.x++;
      }
      break;  
    }
  } // end handle input
}

//========================================================================================================================
//                                                     Draw
//========================================================================================================================
_mapEngine.prototype.draw = function()
{
  //var time = GetTime();
  //Rectangle(0, 0, 640, 480, CreateColor(170, 170, 170, 155));
  
  var tileX = Math.floor(this.x / 32);
  var tileY = Math.floor(this.y / 32);
  
  this.xOffset = this.x - (tileX * 32);
  this.yOffset = this.y - (tileY * 32);
  
  this.screenWidth = (GetScreenWidth() + this.xOffset) / 32;
  this.screenHeight = (GetScreenHeight()  + this.yOffset) / 32;
  
  for (var l = 0; l < this.layer.length; l++) 
  {
    var tempArray = [];
    for (var i = 0; i < this.layer[l].entities.length; i++)
    {
      tempArray["x" + this.layer[l].entities[i].tileX + "y" + this.layer[l].entities[i].tileY] = this.layer[l].entities[i];
    }
    for (var y = 0 - this.numLayers; y < this.screenHeight - this.numLayers + 1; y++)
    {
      for (var x = 0 - this.numLayers; x < this.screenWidth - this.numLayers + 1; x++)
      {
        if (this.layer[l].base[tileY + y + l] && this.layer[l].base[tileY + y + l][tileX + x + l])
        {
          this.tileset[this.layer[l].base[tileY + y + l][tileX + x + l]].image.blit(((32 * this.numLayers)) + (x * 32) - this.xOffset, (32 * this.numLayers) + (y * 32) - this.yOffset);
        }
        if (this.layer[l].objects[tileY + y + l] && this.layer[l].objects[tileY + y + l][tileX + x + l] != undefined)
        {
          mapBuilder.objectsPanel.objects[this.layer[l].objects[tileY + y + l][tileX + x + l]].image.blit((32 * this.numLayers) + (x * 32) - 32 - this.xOffset, (32 * this.numLayers) + (y * 32) - 32 - this.yOffset);
        }
        if (tempArray["x"+(tileX + x + l)+"y"+(tileY + y + l)])
        {
          //tempArray["x"+(xx)+"y"+(yy)].image.blit(xxx + (x * 32), (this.windowY + (32 * this.numLayers)) + (y * 32))
          player.blit(((32 * this.numLayers)) + (x * 32) - this.xOffset, (32 * this.numLayers) + (y * 32) - this.yOffset);
        }
      }
    }
  }
  player.blit((GetScreenWidth() / 2) - 16, (GetScreenHeight() / 2) - 16);
  //OutlinedRectangle((GetScreenWidth() / 2) - 16, (GetScreenHeight() / 2) - 16, 32, 32, CreateColor(0, 0, 0, 255));
  drawText(0, 20, "Map engine is running");
  drawText(0, 36, "Top Left X: " + tileX);
  drawText(0, 52, "Top Left Y: " + tileY);
  if (IsKeyPressed(KEY_ESCAPE))
    {
      var testScreen = GrabImage(0, 0, 640, 480).createSurface();
      testScreen.save("Screen.png");
      Exit();
    }
  FlipScreen();
}

//========================================================================================================================
//                                                     Execute
//========================================================================================================================

_mapEngine.prototype.execute = function()
{
  while (this)
  {
    this.handleInput();
    this.update();
    this.draw();
  }
}
